@extends('layouts.app')

@section('title', 'All Prescriptions')

@section('content')
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">All Prescriptions</h1>
        <a href="{{ route('admin.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back to Dashboard</span><span class="sm:hidden">Back</span>
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Prescription #</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden sm:table-cell">Doctor</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Diagnosis</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Items</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($prescriptions as $prescription)
                <tr>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="font-medium text-sm sm:text-base">{{ $prescription->prescription_number }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <div>
                            <div class="font-medium text-sm sm:text-base">{{ $prescription->patient->full_name }}</div>
                            <div class="text-xs sm:text-sm text-gray-500">{{ $prescription->patient->patient_id }}</div>
                        </div>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden sm:table-cell">
                        <span class="text-sm">{{ $prescription->doctor->full_name ?? 'N/A' }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="text-xs sm:text-sm">{{ $prescription->created_at->format('M d, Y') }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 hidden md:table-cell">
                        <span class="text-xs sm:text-sm">{{ $prescription->diagnosis ?? 'N/A' }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded text-xs">
                            {{ $prescription->items->count() }} item(s)
                        </span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-xs sm:text-sm font-medium">
                        <div class="flex flex-col sm:flex-row gap-1 sm:gap-2">
                            <a href="{{ route('prescriptions.show', $prescription->id) }}" class="text-blue-600 hover:text-blue-900">
                                <i class="fas fa-eye"></i> <span class="hidden sm:inline">View</span>
                            </a>
                            <a href="{{ route('prescriptions.download', $prescription->id) }}" class="text-green-600 hover:text-green-900">
                                <i class="fas fa-download"></i> <span class="hidden sm:inline">Download</span>
                            </a>
                            <form method="POST" action="{{ route('admin.prescriptions.delete', $prescription->id) }}" class="inline" onsubmit="return confirm('Are you sure you want to delete this prescription? This action cannot be undone.')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-900">
                                    <i class="fas fa-trash"></i> <span class="hidden sm:inline">Delete</span>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                        No prescriptions found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
        </div>
    </div>

    @if($prescriptions->count() > 0)
    <div class="mt-4 text-sm text-gray-600">
        Showing {{ $prescriptions->count() }} prescription(s)
    </div>
    @endif
</div>
@endsection

